/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DevNetAp_Functionlist.h 48469 2014-10-09 08:32:07Z trieu              $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------

*******************************************************************************/
/**
 * @file DevNetAp_Functionlist.h
 * @brief DevNet Ap - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_DevNetAp</code>
 * of task.
 */
#ifndef __DEVNET_AP_FUNCTIONLIST_H
#define __DEVNET_AP_FUNCTIONLIST_H


/******************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_DevNetAp
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_DevNetAp
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_DevNetAp
(
 TLR_VOID FAR* pvInit
);

/** @} */


/******************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define DEVNET_AP_STARTUP_PARAM_VERSION (1)


/******************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

typedef struct DNM_APP_CIP_DEVICEID_DATA_Ttag
{
  TLR_UINT32 ulEnable;
  TLR_UINT16 usVendorID;
  TLR_UINT16 usDeviceType;
  TLR_UINT16 usProductCode;
  TLR_UINT8  bMajRev;
  TLR_UINT8  bMinRev;
  TLR_UINT8  abProductName[32];
} DNM_APP_CIP_DEVICEID_DATA_T;

/** task startup parameter */
typedef struct DEVNET_AP_STARTUPPARAMETER_Ttag  DEVNET_AP_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
#define DNM_AP_TASK_STARTUP_PARAM_V2 (2)
#define DNM_AP_TASK_STARTUP_PARAM_V3 (3)
#define DNM_AP_TASK_STARTUP_PARAM_V DNM_AP_TASK_STARTUP_PARAM_V3

/** LED instance */

typedef struct DNMAP_LED_CONFIG_Ttag  DNMAP_LED_CONFIG_T;

struct DNMAP_LED_CONFIG_Ttag
{
  STRING     szName[16];
  TLR_UINT32 ulLedInst;
};

struct DEVNET_AP_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  /** Dualport Channel Instance to work with */
  TLR_UINT32  ulDPMChannel;

  /****************************************************************************/
  /*                     CIP Device ID: Use for taglist                       */
  /****************************************************************************/
  DNM_APP_CIP_DEVICEID_DATA_T tDeviceId;

  DNMAP_LED_CONFIG_T          tGrnLed;

  DNMAP_LED_CONFIG_T          tRedLed;
};
/** @} */


/*************************************************************************************/
#endif /* #ifndef __DEVNET_AP_FUNCTIONLIST_H */
